<?php
$logFile = __DIR__ . '/logs/tracking.log';

function tailFile($file, $lines = 100) {
    if (!file_exists($file)) return [];

    $f = fopen($file, "r");
    $buffer = '';
    $pos = -1;
    $cnt = 0;

    while ($cnt < $lines && fseek($f, $pos, SEEK_END) !== -1) {
        $char = fgetc($f);
        if ($char === "\n") $cnt++;
        $buffer = $char . $buffer;
        $pos--;
    }
    fclose($f);
    return array_filter(explode("\n", trim($buffer)));
}

$rawLines = tailFile($logFile, 100);
$data = [];

foreach (array_reverse($rawLines) as $line) {
    $parts = explode('|', $line);
    if (count($parts) !== 3) continue;

    $data[] = [
        'time'  => $parts[0],
        'ip'    => $parts[1],
        'email' => $parts[2]
    ];
}

header('Content-Type: application/json');
echo json_encode($data);
